<?php

class AnnouncementsController extends Controller
{
    public function index(): void
    {
        $model  = new Announcement();
        $page   = max(1, (int)($_GET['page'] ?? 1));
        $limit  = 10;
        $offset = ($page - 1) * $limit;
        $items  = $model->allPaginated($limit, $offset);

        $this->view('announcements/index', [
            'title'         => 'Announcements',
            'announcements' => $items,
            'page'          => $page,
        ]);
    }

    public function bookmark(int $id): void
    {
        if (empty($_SESSION['user'])) {
            $this->redirect('/auth/login');
        }

        if (!$this->isPost() || !$this->verifyCsrf()) {
            http_response_code(400);
            echo 'Bad request';
            return;
        }

        $bookmarkModel = new Bookmark();
        $bookmarkModel->toggleAnnouncement((int)$_SESSION['user']['id'], $id);

        $this->redirect('/announcements');
    }
}

