<?php

class MessagesController extends Controller
{
    public function index(): void
    {
        if (empty($_SESSION['user'])) {
            $this->redirect('/auth/login');
        }

        $userId      = (int)$_SESSION['user']['id'];
        $messageModel = new Message();

        $inbox = $messageModel->inbox($userId, 20, 0);
        $sent  = $messageModel->sentItems($userId, 20, 0);

        $this->view('messages/index', [
            'title' => 'Messages',
            'inbox' => $inbox,
            'sent'  => $sent,
        ]);
    }

    public function compose(): void
    {
        if (empty($_SESSION['user'])) {
            $this->redirect('/auth/login');
        }

        if ($this->isPost()) {
            if (!$this->verifyCsrf()) {
                http_response_code(400);
                echo 'Invalid CSRF token';
                return;
            }

            $toStudentId = trim($_POST['to_student_id'] ?? '');
            $body        = trim($_POST['body'] ?? '');

            $errors = [];
            if ($toStudentId === '' || $body === '') {
                $errors[] = 'Recipient ID and message body are required.';
            }

            $userModel = new User();
            $receiver  = $userModel->findByStudentId($toStudentId);
            if (!$receiver) {
                $errors[] = 'No user found with that Student ID.';
            }

            if (empty($errors)) {
                $messageModel     = new Message();
                $notificationModel = new Notification();

                $messageModel->send((int)$_SESSION['user']['id'], (int)$receiver['id'], $body);

                // Notification to receiver
                $notificationModel->create(
                    (int)$receiver['id'],
                    'private_message',
                    [
                        'from' => $_SESSION['user']['name'] ?? $_SESSION['user']['student_id'],
                    ]
                );

                $this->redirect('/messages');
                return;
            }

            $this->view('messages/compose', [
                'title'  => 'Compose Message',
                'errors' => $errors,
            ]);
            return;
        }

        $this->view('messages/compose', [
            'title' => 'Compose Message',
        ]);
    }
}

