<?php

class NotificationsController extends Controller
{
    public function index(): void
    {
        if (empty($_SESSION['user'])) {
            $this->redirect('/auth/login');
        }

        $userId      = (int)$_SESSION['user']['id'];
        $model       = new Notification();
        $notifications = $model->allForUser($userId, 50, 0);

        $this->view('notifications/index', [
            'title'         => 'Notifications',
            'notifications' => $notifications,
        ]);
    }

    public function markAllRead(): void
    {
        if (empty($_SESSION['user'])) {
            $this->redirect('/auth/login');
        }

        if (!$this->isPost() || !$this->verifyCsrf()) {
            http_response_code(400);
            echo 'Bad request';
            return;
        }

        $model = new Notification();
        $model->markAllRead((int)$_SESSION['user']['id']);

        $this->redirect('/notifications');
    }
}

