<?php

class Like extends Model
{
    public function toggle(int $postId, int $userId): bool
    {
        // Check if like exists
        $stmt = $this->db->prepare('SELECT id FROM likes WHERE post_id = :post_id AND user_id = :user_id');
        $stmt->execute([
            'post_id' => $postId,
            'user_id' => $userId,
        ]);
        $existing = $stmt->fetch();

        if ($existing) {
            $stmt = $this->db->prepare('DELETE FROM likes WHERE id = :id');
            return $stmt->execute(['id' => $existing['id']]);
        }

        $stmt = $this->db->prepare('INSERT INTO likes (post_id, user_id) VALUES (:post_id, :user_id)');
        return $stmt->execute([
            'post_id' => $postId,
            'user_id' => $userId,
        ]);
    }

    public function getPostsLikedByUser(int $userId): array
    {
        $stmt = $this->db->prepare('SELECT DISTINCT post_id FROM likes WHERE user_id = :user_id ORDER BY created_at DESC');
        $stmt->execute(['user_id' => $userId]);
        $results = $stmt->fetchAll();
        return array_map(fn($r) => (int)$r['post_id'], $results);
    }
}

