<?php

class Message extends Model
{
    public function send(int $senderId, int $receiverId, string $body): int
    {
        $stmt = $this->db->prepare('INSERT INTO messages (sender_id, receiver_id, body)
            VALUES (:sender_id, :receiver_id, :body)');
        $stmt->execute([
            'sender_id'   => $senderId,
            'receiver_id' => $receiverId,
            'body'        => $body,
        ]);
        return (int)$this->db->lastInsertId();
    }

    public function inbox(int $userId, int $limit = 20, int $offset = 0): array
    {
        $sql = 'SELECT m.*, u.student_id AS sender_student_id, p.full_name AS sender_name
                FROM messages m
                JOIN users u ON u.id = m.sender_id
                LEFT JOIN profiles p ON p.user_id = u.id
                WHERE m.receiver_id = ?
                ORDER BY m.created_at DESC
                LIMIT ? OFFSET ?';
        $stmt = $this->db->prepare($sql);
        $stmt->execute([$userId, $limit, $offset]);
        return $stmt->fetchAll();
    }

    public function sentItems(int $userId, int $limit = 20, int $offset = 0): array
    {
        $sql = 'SELECT m.*, u.student_id AS receiver_student_id, p.full_name AS receiver_name
                FROM messages m
                JOIN users u ON u.id = m.receiver_id
                LEFT JOIN profiles p ON p.user_id = u.id
                WHERE m.sender_id = ?
                ORDER BY m.created_at DESC
                LIMIT ? OFFSET ?';
        $stmt = $this->db->prepare($sql);
        $stmt->execute([$userId, $limit, $offset]);
        return $stmt->fetchAll();
    }

    public function markAsRead(int $messageId, int $userId): bool
    {
        $stmt = $this->db->prepare('UPDATE messages SET is_read = 1 
            WHERE id = :id AND receiver_id = :user_id');
        return $stmt->execute([
            'id'      => $messageId,
            'user_id' => $userId,
        ]);
    }
}

