<?php

class Repost extends Model
{
    public function toggle(int $postId, int $userId): bool
    {
        // Check if user has already reposted
        $stmt = $this->db->prepare('SELECT id FROM reposts WHERE post_id = :post_id AND user_id = :user_id');
        $stmt->execute([
            'post_id' => $postId,
            'user_id' => $userId,
        ]);
        
        if ($stmt->fetch()) {
            // Remove repost
            $stmt = $this->db->prepare('DELETE FROM reposts WHERE post_id = :post_id AND user_id = :user_id');
            return $stmt->execute([
                'post_id' => $postId,
                'user_id' => $userId,
            ]);
        } else {
            // Add repost
            $stmt = $this->db->prepare('INSERT INTO reposts (post_id, user_id) VALUES (:post_id, :user_id)');
            return $stmt->execute([
                'post_id' => $postId,
                'user_id' => $userId,
            ]);
        }
    }

    public function getCount(int $postId): int
    {
        $stmt = $this->db->prepare('SELECT COUNT(*) as count FROM reposts WHERE post_id = :post_id');
        $stmt->execute(['post_id' => $postId]);
        $result = $stmt->fetch();
        return (int)($result['count'] ?? 0);
    }

    public function hasReposted(int $postId, int $userId): bool
    {
        $stmt = $this->db->prepare('SELECT id FROM reposts WHERE post_id = :post_id AND user_id = :user_id');
        $stmt->execute([
            'post_id' => $postId,
            'user_id' => $userId,
        ]);
        return (bool)$stmt->fetch();
    }

    public function getByUser(int $userId, int $limit = 20, int $offset = 0): array
    {
        $stmt = $this->db->prepare('
            SELECT p.*, u.student_id, pr.full_name, 
                   COUNT(DISTINCT c.id) as comments_count,
                   COUNT(DISTINCT l.id) as likes_count,
                   COUNT(DISTINCT r.id) as reposts_count
            FROM posts p
            JOIN users u ON u.id = p.user_id
            LEFT JOIN profiles pr ON pr.user_id = u.id
            LEFT JOIN comments c ON c.post_id = p.id
            LEFT JOIN likes l ON l.post_id = p.id
            LEFT JOIN reposts r ON r.post_id = p.id
            JOIN reposts ur ON ur.post_id = p.id AND ur.user_id = :user_id
            WHERE p.is_deleted = 0
            GROUP BY p.id
            ORDER BY ur.created_at DESC
            LIMIT ? OFFSET ?
        ');
        $stmt->execute([$userId, $limit, $offset]);
        return $stmt->fetchAll() ?: [];
    }

    public function getPostsRepostedByUser(int $userId): array
    {
        $stmt = $this->db->prepare('SELECT DISTINCT post_id FROM reposts WHERE user_id = :user_id ORDER BY created_at DESC');
        $stmt->execute(['user_id' => $userId]);
        $results = $stmt->fetchAll();
        return array_map(fn($r) => (int)$r['post_id'], $results);
    }
}
