<div class="max-w-2xl mx-auto bg-white rounded-xl shadow-sm border border-slate-200 p-6">
    <h1 class="text-lg font-semibold text-slate-800 mb-4">New Announcement</h1>

    <?php if (!empty($errors)): ?>
        <div class="mb-4 rounded border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-700 space-y-1">
            <?php foreach ($errors as $e): ?>
                <p><?= htmlspecialchars($e) ?></p>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <form method="post" action="<?= BASE_URL ?>/admin/newAnnouncement" class="space-y-4" enctype="multipart/form-data">
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">

        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1" for="title">Title</label>
            <input
                type="text"
                id="title"
                name="title"
                required
                class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-emerald-500"
            >
        </div>

        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1" for="body">Body</label>
            <textarea
                id="body"
                name="body"
                rows="6"
                required
                class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-emerald-500"
            ></textarea>
        </div>

        <!-- Media Upload Section -->
        <div class="border-t border-slate-200 pt-4">
            <label class="block text-sm font-medium text-slate-700 mb-2">Attach Images or Videos (optional)</label>
            <div class="border-2 border-dashed border-slate-300 rounded-lg p-4 text-center cursor-pointer hover:border-emerald-500 transition" id="dropZone">
                <svg class="w-8 h-8 text-slate-400 mx-auto mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
                <p class="text-sm text-slate-600">Drag and drop images or videos here, or click to select</p>
                <p class="text-xs text-slate-500 mt-1">Max 50MB per file • JPG, PNG, GIF, WebP, MP4, MOV, etc.</p>
                <input
                    type="file"
                    name="media[]"
                    multiple
                    accept="image/*,video/*"
                    class="hidden"
                    id="mediaInput"
                >
            </div>
            <div id="mediaPreview" class="mt-3 space-y-2"></div>
        </div>

        <div class="grid sm:grid-cols-2 gap-4 text-xs">
            <label class="inline-flex items-center gap-2">
                <input type="checkbox" name="pinned" value="1" class="rounded border-slate-300 text-emerald-600">
                <span>Pin announcement</span>
            </label>
            <label class="inline-flex items-center gap-2">
                <input type="checkbox" name="is_active" value="1" checked class="rounded border-slate-300 text-emerald-600">
                <span>Active</span>
            </label>
        </div>

        <div class="grid sm:grid-cols-2 gap-4">
            <div>
                <label class="block text-xs font-medium text-slate-700 mb-1" for="starts_at">Start (optional)</label>
                <input
                    type="datetime-local"
                    id="starts_at"
                    name="starts_at"
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-xs focus:border-emerald-500 focus:ring-emerald-500"
                >
            </div>
            <div>
                <label class="block text-xs font-medium text-slate-700 mb-1" for="ends_at">End (optional)</label>
                <input
                    type="datetime-local"
                    id="ends_at"
                    name="ends_at"
                    class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-xs focus:border-emerald-500 focus:ring-emerald-500"
                >
            </div>
        </div>

        <div class="flex items-center gap-2">
            <button
                type="submit"
                class="bg-emerald-700 hover:bg-emerald-800 text-white text-sm font-medium px-4 py-2 rounded-lg"
            >
                Publish
            </button>
            <a href="<?= BASE_URL ?>/admin/announcements" class="text-xs text-slate-500 hover:underline">Cancel</a>
        </div>
    </form>

    <script>
        const dropZone = document.getElementById('dropZone');
        const mediaInput = document.getElementById('mediaInput');
        const mediaPreview = document.getElementById('mediaPreview');

        dropZone.addEventListener('click', () => mediaInput.click());

        dropZone.addEventListener('dragover', (e) => {
            e.preventDefault();
            dropZone.classList.add('border-emerald-500', 'bg-emerald-50');
        });

        dropZone.addEventListener('dragleave', () => {
            dropZone.classList.remove('border-emerald-500', 'bg-emerald-50');
        });

        dropZone.addEventListener('drop', (e) => {
            e.preventDefault();
            dropZone.classList.remove('border-emerald-500', 'bg-emerald-50');
            mediaInput.files = e.dataTransfer.files;
            updateMediaPreview();
        });

        mediaInput.addEventListener('change', updateMediaPreview);

        function updateMediaPreview() {
            mediaPreview.innerHTML = '';
            const files = Array.from(mediaInput.files);
            
            files.forEach((file, index) => {
                const isImage = file.type.startsWith('image/');
                const isVideo = file.type.startsWith('video/');
                
                const preview = document.createElement('div');
                preview.className = 'flex items-center justify-between bg-slate-50 p-3 rounded-lg border border-slate-200';
                
                let icon = '📎';
                if (isImage) icon = '🖼️';
                if (isVideo) icon = '🎬';
                
                const sizeMB = (file.size / (1024 * 1024)).toFixed(2);
                preview.innerHTML = `
                    <div class="flex items-center gap-2">
                        <span class="text-lg">${icon}</span>
                        <div class="text-sm">
                            <p class="font-medium text-slate-800">${file.name}</p>
                            <p class="text-xs text-slate-500">${sizeMB} MB</p>
                        </div>
                    </div>
                `;
                mediaPreview.appendChild(preview);
            });
        }
    </script>
</div>
