<div class="flex items-center justify-between mb-4">
    <h1 class="text-xl font-semibold text-slate-800">User Management</h1>
    <a href="<?= BASE_URL ?>/admin" class="text-xs text-emerald-700 hover:underline">Back to dashboard</a>
</div>

<div class="bg-white rounded-xl shadow-sm border border-slate-200 overflow-x-auto">
    <table class="min-w-full text-xs">
        <thead class="bg-slate-50 text-slate-600">
            <tr>
                <th class="px-3 py-2 text-left">Student ID</th>
                <th class="px-3 py-2 text-left">Name</th>
                <th class="px-3 py-2 text-left">Institution</th>
                <th class="px-3 py-2 text-left">Role</th>
                <th class="px-3 py-2 text-left">Status</th>
                <th class="px-3 py-2 text-left">Actions</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-slate-100">
            <?php foreach ($users as $u): ?>
                <tr>
                    <td class="px-3 py-2 font-mono text-[11px]"><?= htmlspecialchars($u['student_id']) ?></td>
                    <td class="px-3 py-2"><?= htmlspecialchars($u['full_name'] ?? '-') ?></td>
                    <td class="px-3 py-2"><?= htmlspecialchars($u['institution'] ?? '-') ?></td>
                    <td class="px-3 py-2"><?= htmlspecialchars($u['role']) ?></td>
                    <td class="px-3 py-2">
                        <?php if ($u['status'] === 'active'): ?>
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-emerald-50 text-emerald-700 text-[10px] uppercase tracking-wide">Active</span>
                        <?php else: ?>
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-red-50 text-red-700 text-[10px] uppercase tracking-wide">Suspended</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-3 py-2">
                        <form method="post" action="<?= BASE_URL ?>/admin/toggleUserStatus/<?= (int)$u['id'] ?>">
                            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
                            <button class="text-[11px] px-2 py-1 rounded border border-slate-200 hover:bg-slate-50">
                                <?= $u['status'] === 'active' ? 'Suspend' : 'Activate' ?>
                            </button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

