<?php
// Check if user is already logged in
if (!empty($_SESSION['user'])) {
    header('Location: ' . BASE_URL . '/home');
    exit;
}
?>

<div class="min-h-screen bg-slate-50 flex items-center justify-center px-4 py-12">
    <div class="w-full max-w-md">
        <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-8">
            <!-- Header -->
            <div class="text-center mb-8">
                <h1 class="text-2xl font-bold text-slate-900 mb-2">Reset Your Password</h1>
                <p class="text-slate-600">Enter your Student ID to receive a password reset link</p>
            </div>

            <!-- Error Messages -->
            <?php if (!empty($error)): ?>
                <div class="mb-4 p-3 bg-red-50 border border-red-200 rounded-lg text-red-700 text-sm">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <!-- Success Message -->
            <?php if (!empty($_SESSION['reset_link'])): ?>
                <div class="mb-4 p-3 bg-emerald-50 border border-emerald-200 rounded-lg text-emerald-700 text-sm">
                    <p class="font-medium mb-2">✓ Reset link generated (testing mode)</p>
                    <p class="text-xs mb-2">Copy this link to reset your password:</p>
                    <code class="block bg-white p-2 rounded border border-emerald-200 text-xs break-all">
                        <?= htmlspecialchars($_SESSION['reset_link']) ?>
                    </code>
                    <p class="text-xs mt-2 text-emerald-600">
                        (In production, this link would be sent to your email)
                    </p>
                </div>
                <?php unset($_SESSION['reset_link']); ?>
            <?php endif; ?>

            <!-- Form -->
            <form method="POST" action="<?= BASE_URL ?>/auth/forgotPassword" class="space-y-4">
                <!-- CSRF Token -->
                <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

                <!-- Student ID Input -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-2" for="student_id">
                        Student ID
                    </label>
                    <input
                        type="text"
                        id="student_id"
                        name="student_id"
                        placeholder="Enter your Student ID"
                        required
                        class="block w-full rounded-lg border border-slate-300 px-4 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500 focus:outline-none"
                    >
                </div>

                <!-- Submit Button -->
                <button
                    type="submit"
                    class="w-full bg-emerald-700 hover:bg-emerald-800 text-white font-medium py-2 px-4 rounded-lg transition-colors duration-200"
                >
                    Send Reset Link
                </button>
            </form>

            <!-- Back to Login -->
            <div class="mt-6 text-center">
                <p class="text-slate-600 text-sm">
                    Remember your password?
                    <a href="<?= BASE_URL ?>/auth/login" class="text-emerald-700 hover:text-emerald-800 font-medium">
                        Back to Login
                    </a>
                </p>
            </div>
        </div>
    </div>
</div>
