<div class="min-h-[70vh] flex items-center justify-center">
    <div class="w-full max-w-4xl bg-white rounded-2xl shadow-xl overflow-hidden grid md:grid-cols-2">
        <!-- Left: form -->
        <div class="px-8 py-10">
            <div class="mb-6 flex items-center gap-2">
                <div class="h-10 w-10 rounded-full bg-gradient-to-br from-emerald-500 to-purple-600 flex items-center justify-center text-white font-bold text-lg">
                    E
                </div>
                <div>
                    <p class="text-xs uppercase tracking-[0.2em] text-slate-400">PACCPOLICY</p>
                    <p class="text-sm font-semibold text-slate-800">EELL Community</p>
                </div>
            </div>

            <h1 class="text-xl md:text-2xl font-semibold text-slate-900 mb-1">Sign in to Community</h1>
            <p class="text-xs text-slate-500 mb-6">
                Use your Student ID and password to access the Environmental Education & Lifelong Learning space.
            </p>

            <?php if (!empty($error)): ?>
                <div class="mb-4 rounded-xl border border-red-200 bg-red-50 px-3 py-2 text-xs text-red-700">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <form method="post" class="space-y-4">
                <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">

                <div>
                    <label class="block text-xs font-semibold text-slate-600 mb-1" for="student_id">Student ID</label>
                    <div class="flex items-center gap-2 rounded-lg border border-slate-200 px-3 py-2 bg-slate-50 focus-within:border-emerald-500 focus-within:ring-1 focus-within:ring-emerald-500">
                        <span class="text-slate-400 text-xs">&#x1F393;</span>
                        <input
                            type="text"
                            id="student_id"
                            name="student_id"
                            required
                            class="w-full bg-transparent text-sm outline-none placeholder:text-slate-400"
                            placeholder="Enter your Student ID"
                        >
                    </div>
                </div>

                <div>
                    <label class="block text-xs font-semibold text-slate-600 mb-1" for="password">Password</label>
                    <div class="flex items-center gap-2 rounded-lg border border-slate-200 px-3 py-2 bg-slate-50 focus-within:border-emerald-500 focus-within:ring-1 focus-within:ring-emerald-500">
                        <span class="text-slate-400 text-xs">&#x1F512;</span>
                        <input
                            type="password"
                            id="password"
                            name="password"
                            required
                            class="w-full bg-transparent text-sm outline-none placeholder:text-slate-400"
                            placeholder="Enter your password"
                        >
                    </div>
                </div>

                <div class="flex items-center justify-between text-[11px] text-slate-500">
                    <label class="inline-flex items-center gap-2">
                        <input type="checkbox" class="rounded border-slate-300 text-emerald-600">
                        <span>Remember me</span>
                    </label>
                    <a href="<?= BASE_URL ?>/auth/forgotPassword" class="text-emerald-700 hover:underline">Forgot password?</a>
                </div>

                <button
                    type="submit"
                    class="w-full mt-2 bg-gradient-to-r from-emerald-500 to-purple-600 hover:from-emerald-600 hover:to-purple-700 text-white text-sm font-medium py-2.5 rounded-full shadow-lg shadow-purple-500/30"
                >
                    Sign In
                </button>

                <p class="text-[11px] text-slate-500 text-center mt-3">
                    New to the platform?
                    <a href="<?= BASE_URL ?>/auth/register" class="text-emerald-700 font-semibold hover:underline">Join the community</a>
                </p>
            </form>
        </div>

        <!-- Right: promo / gradient -->
        <div class="hidden md:flex relative bg-gradient-to-br from-purple-600 via-purple-500 to-emerald-500 text-white items-center justify-center">
            <div class="absolute inset-0 opacity-20" style="background-image: radial-gradient(circle at 0 0, #ffffff33, transparent 55%), radial-gradient(circle at 100% 100%, #22c55e44, transparent 55%);"></div>
            <div class="relative px-8 py-10 text-center">
                <p class="text-xs uppercase tracking-[0.2em] text-purple-100 mb-3">Environmental Education</p>
                <h2 class="text-2xl font-bold leading-snug mb-2">Join Our Community</h2>
                <p class="text-xs text-purple-100 max-w-xs mx-auto">
                    Learn, share, and take action on climate and environmental issues with students across Ghana, guided by PACCPOLICY.
                </p>
            </div>
        </div>
    </div>
</div>

