<?php
// Check if user is already logged in
if (!empty($_SESSION['user'])) {
    header('Location: ' . BASE_URL . '/home');
    exit;
}
?>

<div class="min-h-screen bg-slate-50 flex items-center justify-center px-4 py-12">
    <div class="w-full max-w-md">
        <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-8">
            <!-- Header -->
            <div class="text-center mb-8">
                <h1 class="text-2xl font-bold text-slate-900 mb-2">Create New Password</h1>
                <p class="text-slate-600">Enter your new password below</p>
            </div>

            <!-- Error Messages -->
            <?php if (!empty($error)): ?>
                <div class="mb-4 p-3 bg-red-50 border border-red-200 rounded-lg text-red-700 text-sm">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($errors) && is_array($errors)): ?>
                <div class="mb-4 p-3 bg-red-50 border border-red-200 rounded-lg text-red-700 text-sm">
                    <?php foreach ($errors as $err): ?>
                        <div>• <?= htmlspecialchars($err) ?></div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <!-- Form -->
            <form method="POST" class="space-y-4">
                <!-- CSRF Token -->
                <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

                <!-- Password Input -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-2" for="password">
                        New Password
                    </label>
                    <input
                        type="password"
                        id="password"
                        name="password"
                        placeholder="At least 8 characters"
                        required
                        minlength="8"
                        class="block w-full rounded-lg border border-slate-300 px-4 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500 focus:outline-none"
                    >
                    <p class="text-xs text-slate-500 mt-1">Must be at least 8 characters long</p>
                </div>

                <!-- Confirm Password Input -->
                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-2" for="confirm_password">
                        Confirm Password
                    </label>
                    <input
                        type="password"
                        id="confirm_password"
                        name="confirm_password"
                        placeholder="Re-enter your password"
                        required
                        minlength="8"
                        class="block w-full rounded-lg border border-slate-300 px-4 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500 focus:outline-none"
                    >
                </div>

                <!-- Submit Button -->
                <button
                    type="submit"
                    class="w-full bg-emerald-700 hover:bg-emerald-800 text-white font-medium py-2 px-4 rounded-lg transition-colors duration-200"
                >
                    Reset Password
                </button>
            </form>

            <!-- Back to Login -->
            <div class="mt-6 text-center">
                <p class="text-slate-600 text-sm">
                    <a href="<?= BASE_URL ?>/auth/login" class="text-emerald-700 hover:text-emerald-800 font-medium">
                        Back to Login
                    </a>
                </p>
            </div>
        </div>
    </div>
</div>
