<div class="max-w-lg mx-auto bg-white rounded-xl shadow-sm border border-slate-200 p-6">
    <h1 class="text-lg font-semibold text-slate-800 mb-4">Compose Message</h1>

    <?php if (!empty($errors)): ?>
        <div class="mb-4 rounded border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-700 space-y-1">
            <?php foreach ($errors as $e): ?>
                <p><?= htmlspecialchars($e) ?></p>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <form method="post" action="<?= BASE_URL ?>/messages/compose" class="space-y-4">
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1" for="to_student_id">To (Student ID)</label>
            <input
                type="text"
                id="to_student_id"
                name="to_student_id"
                required
                class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-emerald-500"
            >
        </div>
        <div>
            <label class="block text-sm font-medium text-slate-700 mb-1" for="body">Message</label>
            <textarea
                id="body"
                name="body"
                rows="5"
                required
                class="block w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-emerald-500"
            ></textarea>
        </div>
        <button
            type="submit"
            class="w-full sm:w-auto bg-emerald-700 hover:bg-emerald-800 text-white text-sm font-medium px-4 py-2 rounded-lg"
        >
            Send Message
        </button>
    </form>
</div>

