<div class="flex items-center justify-between mb-4">
    <h1 class="text-xl font-semibold text-slate-800">Community Posts</h1>
    <?php if (!empty($_SESSION['user'])): ?>
        <a href="<?= BASE_URL ?>/posts/create" class="text-xs sm:text-sm inline-flex items-center gap-1 bg-emerald-700 text-white px-3 py-1.5 rounded-lg hover:bg-emerald-800">
            New Post
        </a>
    <?php endif; ?>
</div>

<?php if (empty($posts)): ?>
    <p class="text-sm text-slate-500">No posts yet. Start the first discussion!</p>
<?php else: ?>
    <div class="space-y-4">
        <?php foreach ($posts as $p): ?>
            <article class="bg-white rounded-xl shadow-sm border border-slate-200 p-4 hover:shadow-md transition">
                <!-- Post Header with Profile Image -->
                <div class="flex items-start justify-between mb-3">
                    <div class="flex items-start gap-3 flex-1">
                        <!-- Profile Image -->
                        <div class="flex-shrink-0 mt-0.5">
                            <?php
                            $profileImage = $p['profile_image'] ?? null;
                            $imageUrl = $profileImage ? BASE_URL . '/uploads/profiles/' . htmlspecialchars($profileImage) : null;
                            ?>
                            <?php if ($imageUrl): ?>
                                <img src="<?= $imageUrl ?>" alt="Profile" class="w-8 h-8 rounded-full object-cover border border-slate-200">
                            <?php else: ?>
                                <div class="w-8 h-8 rounded-full bg-gradient-to-br from-emerald-500 to-purple-600 flex items-center justify-center text-white text-xs font-bold">
                                    <?= strtoupper(substr($p['full_name'] ?? 'U', 0, 1)) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="flex-1 min-w-0">
                            <p class="text-xs text-slate-700 font-medium">
                                <?= htmlspecialchars($p['full_name'] ?? $p['student_id']) ?>
                            </p>
                            <p class="text-[11px] text-slate-400">
                                <?= htmlspecialchars($p['created_at']) ?>
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Post Content -->
                <a href="<?= BASE_URL ?>/posts/show/<?= (int)$p['id'] ?>" class="block group">
                    <h2 class="font-semibold text-slate-900 text-sm sm:text-base line-clamp-2 group-hover:text-emerald-700 transition">
                        <?= htmlspecialchars($p['title']) ?>
                    </h2>
                    <p class="text-xs text-slate-600 mt-2 line-clamp-3">
                        <?= htmlspecialchars(mb_substr($p['body'], 0, 160)) ?><?= mb_strlen($p['body']) > 160 ? '…' : '' ?>
                    </p>
                </a>

                <!-- Media Preview -->
                <?php
                $postModel = new Post();
                $media = $postModel->getPostMedia((int)$p['id']);
                if (!empty($media)): ?>
                    <div class="mt-3 grid grid-cols-2 gap-2">
                        <?php foreach (array_slice($media, 0, 4) as $m): ?>
                            <a href="<?= BASE_URL ?>/posts/show/<?= (int)$p['id'] ?>" class="rounded-lg overflow-hidden bg-slate-100 aspect-square">
                                <?php if ($m['media_type'] === 'image'): ?>
                                    <img src="<?= BASE_URL . htmlspecialchars($m['file_path']) ?>" alt="Post media" class="w-full h-full object-cover">
                                <?php else: ?>
                                    <div class="w-full h-full flex items-center justify-center bg-slate-800">
                                        <span class="text-2xl">🎬</span>
                                    </div>
                                <?php endif; ?>
                            </a>
                        <?php endforeach; ?>
                        <?php if (count($media) > 4): ?>
                            <a href="<?= BASE_URL ?>/posts/show/<?= (int)$p['id'] ?>" class="rounded-lg overflow-hidden bg-slate-100 aspect-square flex items-center justify-center">
                                <span class="text-sm font-semibold text-slate-600">+<?= count($media) - 4 ?> more</span>
                            </a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <!-- Engagement Stats -->
                <div class="flex items-center gap-3 mt-3 pt-3 border-t border-slate-100 text-[11px] text-slate-500">
                    <span>💬 <?= (int)($p['comments_count'] ?? 0) ?> comments</span>
                    <span>❤️ <?= (int)($p['likes_count'] ?? 0) ?> likes</span>
                    <span>🔄 <?= (int)($p['reposts_count'] ?? 0) ?> reposts</span>
                </div>

                <!-- Action Buttons -->
                <div class="flex items-center gap-2 mt-3 pt-3 border-t border-slate-100">
                    <?php if (!empty($_SESSION['user'])): ?>
                        <form method="post" action="<?= BASE_URL ?>/posts/like/<?= (int)$p['id'] ?>" class="flex-1">
                            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
                            <button class="w-full text-xs py-1.5 px-2 rounded-lg border border-slate-200 hover:bg-red-50 hover:border-red-200 hover:text-red-700 transition flex items-center justify-center gap-1">
                                ❤️ Like
                            </button>
                        </form>
                        <form method="post" action="<?= BASE_URL ?>/posts/repost/<?= (int)$p['id'] ?>" class="flex-1">
                            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
                            <button class="w-full text-xs py-1.5 px-2 rounded-lg border border-slate-200 hover:bg-cyan-50 hover:border-cyan-200 hover:text-cyan-700 transition flex items-center justify-center gap-1">
                                🔄 Repost
                            </button>
                        </form>
                            </button>
                        </form>
                        <a href="<?= BASE_URL ?>/posts/show/<?= (int)$p['id'] ?>" class="flex-1 text-xs py-1.5 px-2 rounded-lg border border-slate-200 hover:bg-blue-50 hover:border-blue-200 hover:text-blue-700 transition flex items-center justify-center gap-1">
                            💬 Reply
                        </a>
                        <button onclick="sharePage('<?= htmlspecialchars($p['title']) ?>', '<?= BASE_URL ?>/posts/show/<?= (int)$p['id'] ?>')" class="flex-1 text-xs py-1.5 px-2 rounded-lg border border-slate-200 hover:bg-emerald-50 hover:border-emerald-200 hover:text-emerald-700 transition flex items-center justify-center gap-1">
                            📤 Share
                        </button>
                    <?php else: ?>
                        <p class="text-xs text-slate-500 w-full text-center">
                            <a href="<?= BASE_URL ?>/auth/login" class="text-emerald-700 hover:underline">Login</a> to like and reply
                        </p>
                    <?php endif; ?>
                </div>
            </article>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<script>
function sharePage(title, url) {
    if (navigator.share) {
        navigator.share({
            title: title,
            url: url
        }).catch(err => console.log('Share failed:', err));
    } else {
        const text = `${title}\n${url}`;
        navigator.clipboard.writeText(text).then(() => {
            alert('Post link copied to clipboard!');
        });
    }
}
</script>

