<article class="bg-white rounded-xl shadow-sm border border-slate-200 p-4 mb-4">
    <header class="mb-4">
        <!-- Post Header with Profile Image -->
        <div class="flex items-start gap-3 mb-3">
            <!-- Profile Image -->
            <div class="flex-shrink-0">
                <?php
                $profileImage = $post['profile_image'] ?? null;
                $imageUrl = $profileImage ? BASE_URL . '/uploads/profiles/' . htmlspecialchars($profileImage) : null;
                ?>
                <?php if ($imageUrl): ?>
                    <img src="<?= $imageUrl ?>" alt="Profile" class="w-10 h-10 rounded-full object-cover border border-slate-200">
                <?php else: ?>
                    <div class="w-10 h-10 rounded-full bg-gradient-to-br from-emerald-500 to-purple-600 flex items-center justify-center text-white text-sm font-bold">
                        <?= strtoupper(substr($post['full_name'] ?? 'U', 0, 1)) ?>
                    </div>
                <?php endif; ?>
            </div>
            
            <div class="flex-1 min-w-0">
                <p class="text-sm font-medium text-slate-700">
                    <?= htmlspecialchars($post['full_name'] ?? $post['student_id']) ?>
                </p>
                <p class="text-xs text-slate-500">
                    <?= htmlspecialchars($post['created_at']) ?>
                </p>
            </div>
        </div>
        
        <h1 class="text-lg sm:text-xl font-semibold text-slate-900">
            <?= htmlspecialchars($post['title']) ?>
        </h1>
    </header>
    
    <div class="prose prose-sm max-w-none text-slate-800 mb-4">
        <p><?= nl2br(htmlspecialchars($post['body'])) ?></p>
    </div>

    <!-- Media Gallery -->
    <?php
    $postModel = new Post();
    $media = $postModel->getPostMedia((int)$post['id']);
    if (!empty($media)): ?>
        <div class="mb-4 grid grid-cols-1 sm:grid-cols-2 gap-3 rounded-lg overflow-hidden">
            <?php foreach ($media as $m): ?>
                <?php if ($m['media_type'] === 'image'): ?>
                    <img src="<?= BASE_URL . htmlspecialchars($m['file_path']) ?>" alt="Post media" class="w-full h-auto rounded-lg border border-slate-200">
                <?php else: ?>
                    <video controls class="w-full h-auto rounded-lg border border-slate-200 bg-black">
                        <source src="<?= BASE_URL . htmlspecialchars($m['file_path']) ?>" type="<?= htmlspecialchars($m['mime_type']) ?>">
                        Your browser does not support the video tag.
                    </video>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <!-- Engagement Stats -->
    <div class="flex items-center gap-4 py-3 border-y border-slate-100 text-sm text-slate-600 mb-4">
        <span>❤️ <?= (int)($post['likes_count'] ?? 0) ?> likes</span>
        <span>💬 <?= (int)($post['comments_count'] ?? 0) ?> comments</span>
        <span>🔄 <?= (int)($post['reposts_count'] ?? 0) ?> reposts</span>
    </div>

    <!-- Post Metadata -->
    <div class="mb-4 pb-4 border-b border-slate-100">
        <p class="text-xs text-slate-500">
            Posted by <span class="font-medium text-slate-700"><?= htmlspecialchars($post['full_name'] ?? $post['student_id']) ?></span>
        </p>
    </div>

    <!-- Action Buttons -->
    <div class="flex items-center gap-2">
        <?php if (!empty($_SESSION['user'])): ?>
            <form method="post" action="<?= BASE_URL ?>/posts/like/<?= (int)$post['id'] ?>" class="flex-1">
                <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
                <button class="w-full text-xs py-2 px-3 rounded-lg border border-slate-200 hover:bg-red-50 hover:border-red-200 hover:text-red-700 transition flex items-center justify-center gap-1 font-medium">
                    ❤️ Like
                </button>
            </form>
            <form method="post" action="<?= BASE_URL ?>/posts/repost/<?= (int)$post['id'] ?>" class="flex-1">
                <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
                <button class="w-full text-xs py-2 px-3 rounded-lg border border-slate-200 hover:bg-cyan-50 hover:border-cyan-200 hover:text-cyan-700 transition flex items-center justify-center gap-1 font-medium">
                    🔄 Repost
                </button>
            </form>
            <button onclick="replyToPost()" class="flex-1 text-xs py-2 px-3 rounded-lg border border-slate-200 hover:bg-blue-50 hover:border-blue-200 hover:text-blue-700 transition flex items-center justify-center gap-1 font-medium">
                💬 Reply
            </button>
            <button onclick="sharePagePost('<?= htmlspecialchars($post['title']) ?>', '<?= BASE_URL ?>/posts/show/<?= (int)$post['id'] ?>')" class="flex-1 text-xs py-2 px-3 rounded-lg border border-slate-200 hover:bg-emerald-50 hover:border-emerald-200 hover:text-emerald-700 transition flex items-center justify-center gap-1 font-medium">
                📤 Share
            </button>
            <form method="post" action="<?= BASE_URL ?>/posts/bookmark/<?= (int)$post['id'] ?>" class="flex-1">
                <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
                <button class="w-full text-xs py-2 px-3 rounded-lg border border-slate-200 hover:bg-emerald-50 hover:border-emerald-200 hover:text-emerald-700 transition flex items-center justify-center gap-1 font-medium">
                    🔖 Save
                </button>
            </form>
        <?php else: ?>
            <div class="w-full text-xs text-slate-500 text-center py-2">
                <a href="<?= BASE_URL ?>/auth/login" class="text-emerald-700 font-semibold hover:underline">Login</a> to like, reply, and share
            </div>
        <?php endif; ?>
    </div>
</article>

<section class="bg-white rounded-xl shadow-sm border border-slate-200 p-4">
    <h2 class="text-sm font-semibold text-slate-800 mb-4">💬 Discussion</h2>

    <?php if (!empty($_SESSION['user'])): ?>
        <form method="post" action="<?= BASE_URL ?>/posts/comment/<?= (int)$post['id'] ?>" class="mb-4 space-y-2">
            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
            <div class="bg-slate-50 rounded-lg p-3 border border-slate-200">
                <p class="text-xs text-slate-600 font-medium mb-2">Reply to this post</p>
                <textarea
                    name="body"
                    rows="3"
                    required
                    class="w-full rounded-lg border border-slate-300 px-3 py-2 text-sm focus:border-emerald-500 focus:ring-1 focus:ring-emerald-500 focus:outline-none"
                    placeholder="Share your thoughts about this environmental topic..."
                ></textarea>
            </div>
            <button
                type="submit"
                class="bg-emerald-700 hover:bg-emerald-800 text-white text-xs font-medium px-4 py-2 rounded-lg transition"
            >
                Post Reply
            </button>
        </form>
    <?php else: ?>
        <p class="text-xs text-slate-600 bg-slate-50 rounded-lg p-3 border border-slate-200 mb-4">
            <a href="<?= BASE_URL ?>/auth/login" class="text-emerald-700 font-semibold hover:underline">Login</a> to join the discussion.
        </p>
    <?php endif; ?>

    <?php if (empty($comments)): ?>
        <p class="text-sm text-slate-500 py-4 text-center">No replies yet. Be the first to share your thoughts!</p>
    <?php else: ?>
        <ul class="space-y-3">
            <?php foreach ($comments as $c): ?>
                <li class="bg-slate-50 border border-slate-100 rounded-lg p-3 hover:shadow-sm transition">
                    <p class="text-xs text-slate-600 mb-1.5 flex items-center justify-between">
                        <span>
                            <span class="font-semibold text-slate-800"><?= htmlspecialchars($c['full_name'] ?? $c['student_id']) ?></span>
                            <span class="text-slate-400">· <?= htmlspecialchars($c['created_at']) ?></span>
                        </span>
                    </p>
                    <p class="text-sm text-slate-800"><?= nl2br(htmlspecialchars($c['body'])) ?></p>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
</section>

<script>
function replyToPost() {
    const textarea = document.querySelector('textarea[name="body"]');
    if (textarea) {
        textarea.focus();
        textarea.scrollIntoView({ behavior: 'smooth' });
    }
}

function sharePagePost(title, url) {
    if (navigator.share) {
        navigator.share({
            title: title,
            url: url
        }).catch(err => console.log('Share failed:', err));
    } else {
        const text = `${title}\n${url}`;
        navigator.clipboard.writeText(text).then(() => {
            alert('Post link copied to clipboard!');
        });
    }
}
</script>
