<?php

class Controller
{
    protected array $data = [];

    public function __construct()
    {
        if (session_status() === PHP_SESSION_NONE) {
            session_start([
                'cookie_httponly' => true,
                'cookie_secure'   => isset($_SERVER['HTTPS']),
                'cookie_samesite' => 'Lax',
            ]);
        }
    }

    protected function view(string $view, array $data = []): void
    {
        $this->data = $data;
        extract($data);
        $viewFile = __DIR__ . '/../app/views/' . $view . '.php';
        if (!file_exists($viewFile)) {
            http_response_code(500);
            echo "View not found: " . htmlspecialchars($view);
            return;
        }
        require __DIR__ . '/../app/views/layouts/main.php';
    }

    protected function redirect(string $path): void
    {
        header('Location: ' . BASE_URL . $path);
        exit;
    }

    protected function isPost(): bool
    {
        return $_SERVER['REQUEST_METHOD'] === 'POST';
    }

    protected function csrfToken(): string
    {
        if (empty($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        }
        return $_SESSION['csrf_token'];
    }

    protected function verifyCsrf(): bool
    {
        $token = $_POST['csrf_token'] ?? '';
        return hash_equals($_SESSION['csrf_token'] ?? '', $token);
    }

    protected function requireRole(array $roles): void
    {
        if (empty($_SESSION['user'])) {
            $this->redirect('/auth/login');
        }
        $userRole = $_SESSION['user']['role'] ?? 'student';
        if (!in_array($userRole, $roles, true)) {
            http_response_code(403);
            echo 'Access denied.';
            exit;
        }
    }
}

