<?php

declare(strict_types=1);

// Front controller

spl_autoload_register(function ($class) {
    $paths = [
        __DIR__ . '/../core/' . $class . '.php',
        __DIR__ . '/../app/controllers/' . $class . '.php',
        __DIR__ . '/../app/models/' . $class . '.php',
    ];
    foreach ($paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            return;
        }
    }
});

// Define BASE_URL
$scriptDir = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
// Remove /public if it exists in the script path (due to rewrite)
$baseUrl = str_replace('/public', '', $scriptDir);
define('BASE_URL', rtrim($baseUrl, '/'));

// Basic routing: /controller/action/param1/param2
// Check if .htaccess passed the URL via query parameter
if (!empty($_GET['url'])) {
    $requestUri = $_GET['url'];
} else {
    $requestUri = strtok($_SERVER['REQUEST_URI'], '?');

    // Remove BASE_URL from the request URI to get the internal path
    if (BASE_URL !== '' && strpos($requestUri, BASE_URL) === 0) {
        $requestUri = substr($requestUri, strlen(BASE_URL));
    }
}

$requestUri = trim($requestUri, '/');
$segments   = $requestUri === '' ? [] : explode('/', $requestUri);

$controllerName = !empty($segments[0]) ? ucfirst($segments[0]) . 'Controller' : 'HomeController';
$actionName     = $segments[1] ?? 'index';
$params         = array_slice($segments, 2);

// Cast numeric parameters to integers
$params = array_map(function($param) {
    return is_numeric($param) ? (int)$param : $param;
}, $params);

if (!class_exists($controllerName)) {
    $controllerName = 'HomeController';
}

$controller = new $controllerName();

if (!method_exists($controller, $actionName)) {
    $actionName = 'index';
}

call_user_func_array([$controller, $actionName], $params);

